<?php
include 'conexao.php';

if (!isset($_POST['aluno_id'])) {
    echo "Aluno não selecionado.";
    exit;
}

$aluno_id = $_POST['aluno_id'];

// Buscar nome do aluno
$stmtAluno = $conn->prepare("SELECT nome FROM alunos WHERE id = ?");
$stmtAluno->bind_param("i", $aluno_id);
$stmtAluno->execute();
$aluno = $stmtAluno->get_result()->fetch_assoc();

// Buscar histórico de matrículas
$stmt = $conn->prepare("
    SELECT t.nome AS nome_turma, t.classe, t.curso, t.turno, t.ano, m.ano_letivo

    FROM matriculas m
    INNER JOIN turmas t ON m.turma_id = t.id
    WHERE m.aluno_id = ?
    ORDER BY m.ano_letivo DESC
");
$stmt->bind_param("i", $aluno_id);
$stmt->execute();
$historico = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Histórico do Aluno</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        h2 { margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { padding: 10px; border: 1px solid #ccc; }
        th { background-color: #007bff; color: white; }
    </style>
</head>
<body>
    <h2>📋 Histórico de Matrículas de <?= htmlspecialchars($aluno['nome']) ?></h2>

    <?php if (count($historico) > 0): ?>
        <table>
            <thead>
                <tr>
                    <th>Classe</th>
                    <th>Turma</th>
                    <th>Curso</th>
                    <th>Turno</th>
                 
                    <th>Ano Letivo</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($historico as $linha): ?>
                    <tr>
                        <td><?= htmlspecialchars($linha['classe']) ?></td>
                        <td><?= htmlspecialchars($linha['nome_turma']) ?></td>
                        <td><?= htmlspecialchars($linha['curso']) ?></td>
                        <td><?= htmlspecialchars($linha['turno']) ?></td>
                        
                        <td><?= htmlspecialchars($linha['ano_letivo']) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>Este aluno ainda não tem matrículas registradas.</p>
    <?php endif; ?>
</body>
</html>
